#pragma once

#include "QQUser.h"
#include "QQProtocol.h"
#include "LoginTask.h"
#include "LogoutTask.h"
#include "SendMsgTask.h"
#include "RecvMsgTask.h"
#include "PollTask.h"
#include "InfoTask.h"
#include "GetGroupFaceSigTask.h"
#include "ChangeStatusTask.h"

class CQQClient
{
public:
	CQQClient(void);
	~CQQClient(void);

public:
	BOOL Init();										// ʼͻ
	void UnInit();										// ʼͻ

	void SetUser(LPCTSTR lpQQNum, LPCTSTR lpQQPwd);		// QQ
	void SetLoginStatus(QQ_STATUS nStatus);				// õ¼״̬
	void SetCallBackWnd(HWND hCallBackWnd);				// ûصھ
	void SetVerifyCode(LPCTSTR lpVerifyCode);			// ֤

	BOOL Login();										// ¼
	BOOL Logout();										// ע

	void CancelLogin();									// ȡ¼
	
	void ChangeStatus(QQ_STATUS nStatus);				// ı״̬
	void UpdateBuddyList();								// ºб
	void UpdateGroupList();								// Ⱥб
	void UpdateRecentList();							// ϵб
	void UpdateBuddyInfo(UINT nQQUin);					// ºϢ
	void UpdateGroupMemberInfo(UINT nGroupCode, UINT nQQUin);	// ȺԱϢ
	void UpdateGroupInfo(UINT nGroupCode);				// ȺϢ
	void UpdateBuddyNum(UINT nQQUin);					// ºѺ
	void UpdateGroupMemberNum(UINT nGroupCode, UINT nQQUin);	// ȺԱ
	void UpdateGroupMemberNum(UINT nGroupCode, std::vector<UINT> * arrQQUin);	// ȺԱ
	void UpdateGroupNum(UINT nGroupCode);				// Ⱥ
	void UpdateBuddySign(UINT nQQUin);					// ºѸǩ
	void UpdateGroupMemberSign(UINT nGroupCode, UINT nQQUin);	// ȺԱǩ
	void ModifyQQSign(LPCTSTR lpSign);					// ޸QQǩ
	void UpdateBuddyHeadPic(UINT nQQUin, UINT nQQNum);			// ºͷ
	void UpdateGroupMemberHeadPic(UINT nGroupCode, UINT nQQUin, UINT nQQNum);// ȺԱͷ
	void UpdateGroupHeadPic(UINT nGroupCode, UINT nGroupNum);	// Ⱥͷ
	void UpdateGroupFaceSignal();						// Ⱥ
	BOOL SendBuddyMsg(UINT nToUin, time_t nTime, LPCTSTR lpMsg);				// ͺϢ
	BOOL SendGroupMsg(UINT nGroupId, time_t nTime, LPCTSTR lpMsg);				// ȺϢ
	BOOL SendSessMsg(UINT nGroupId, UINT nToUin, time_t nTime, LPCTSTR lpMsg);	// ʱỰϢ

	BOOL IsOffline();									// Ƿ״̬
	QQ_STATUS GetStatus();								// ȡ״̬
	BOOL GetVerifyCodePic(const BYTE *& lpData, DWORD& dwSize);	// ȡ֤ͼƬ

	CBuddyInfo * GetUserInfo();							// ȡûϢ
	CBuddyList * GetBuddyList();						// ȡб
	CGroupList * GetGroupList();						// ȡȺб
	CRecentList * GetRecentList();						// ȡϵб
	CMessageList * GetMessageList();					// ȡϢб
	CMessageLogger * GetMsgLogger();					// ȡϢ¼

	tstring GetUserFolder();							// ȡûļд·
	void SetUserFolder(LPCTSTR lpPath);					// ûļд·

	tstring GetPersonalFolder(UINT nUserNum = 0);		// ȡļд·
	tstring GetChatPicFolder(UINT nUserNum = 0);		// ȡͼƬ·

	tstring GetUserHeadPicFullName(UINT nUserNum = 0);	// ȡûͷͼƬȫ·ļ
	tstring GetBuddyHeadPicFullName(UINT nQQNum);		// ȡͷͼƬȫ·ļ
	tstring GetGroupHeadPicFullName(UINT nGroupNum);	// ȡȺͷͼƬȫ·ļ
	tstring GetSessHeadPicFullName(UINT nQQNum);		// ȡȺԱͷͼƬȫ·ļ
	tstring GetChatPicFullName(LPCTSTR lpszFileName);	// ȡͼƬȫ·ļ
	tstring GetMsgLogFullName(UINT nUserNum = 0);		// ȡϢ¼ȫ·ļ

	BOOL IsNeedUpdateBuddyHeadPic(UINT nQQNum);			// жǷҪºͷ
	BOOL IsNeedUpdateGroupHeadPic(UINT nGroupNum);		// жǷҪȺͷ
	BOOL IsNeedUpdateSessHeadPic(UINT nQQNum);			// жǷҪȺԱͷ

	time_t GetServerTime();								// ȡʱ

private:
	void OnUpdateBuddyList(UINT message, WPARAM wParam, LPARAM lParam);
	void OnUpdateGroupList(UINT message, WPARAM wParam, LPARAM lParam);
	void OnUpdateRecentList(UINT message, WPARAM wParam, LPARAM lParam);
	void OnBuddyMsg(UINT message, WPARAM wParam, LPARAM lParam);
	void OnGroupMsg(UINT message, WPARAM wParam, LPARAM lParam);
	void OnSessMsg(UINT message, WPARAM wParam, LPARAM lParam);
	void OnSysGroupMsg(UINT message, WPARAM wParam, LPARAM lParam);
	void OnStatusChangeMsg(UINT message, WPARAM wParam, LPARAM lParam);
	void OnKickMsg(UINT message, WPARAM wParam, LPARAM lParam);
	void OnUpdateBuddyNumber(UINT message, WPARAM wParam, LPARAM lParam);
	void OnUpdateGMemberNumber(UINT message, WPARAM wParam, LPARAM lParam);
	void OnUpdateGroupNumber(UINT message, WPARAM wParam, LPARAM lParam);
	void OnUpdateBuddySign(UINT message, WPARAM wParam, LPARAM lParam);
	void OnUpdateGMemberSign(UINT message, WPARAM wParam, LPARAM lParam);
	void OnUpdateBuddyInfo(UINT message, WPARAM wParam, LPARAM lParam);
	void OnUpdateGMemberInfo(UINT message, WPARAM wParam, LPARAM lParam);
	void OnUpdateGroupInfo(UINT message, WPARAM wParam, LPARAM lParam);
	void OnUpdateC2CMsgSig(UINT message, WPARAM wParam, LPARAM lParam);
	void OnChangeStatusResult(UINT message, WPARAM wParam, LPARAM lParam);

	void OnInternal_GetBuddyData(UINT message, WPARAM wParam, LPARAM lParam);
	void OnInternal_GetGroupData(UINT message, WPARAM wParam, LPARAM lParam);
	void OnInternal_GetGMemberData(UINT message, WPARAM wParam, LPARAM lParam);
	UINT OnInternal_GroupId2Code(UINT message, WPARAM wParam, LPARAM lParam);

	BOOL CreateProxyWnd();		// 
	BOOL DestroyProxyWnd();		// ٴ
	static LRESULT CALLBACK ProxyWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

private:
	CQQUser m_QQUser;
	CQQProtocol m_QQProtocol;
	CThreadPool m_ThreadPool;
	CLoginTask m_LoginTask;
	CLogoutTask m_LogoutTask;
	CSendMsgTask m_SendMsgTask;
	CRecvMsgTask m_RecvMsgTask;
	CPollTask m_PollTask;
};
